﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using CoAP.Server;
using CoAP.Server.Resources;

namespace ConsoleApplication2
{


    class HelloWorldResource : Resource
    {
        // use "helloworld" as the path of this resource
        public HelloWorldResource() : base("helloworld")
        {
            // set a friendly title
            Attributes.Title = "GET a friendly greeting!";
        }

        // override this method to handle GET requests
        protected override void DoGet(CoapExchange exchange)
        {
            // now we get a request, respond it
            exchange.Respond("Hello World!");
        }
    }

    class Program
    {
        static void Main(string[] args)
        {
            // create a new server
            CoapServer server = new CoapServer();

            // add the resource to share
            server.Add(new HelloWorldResource());
            try
            {
                server.Start();

                Console.Write("CoAP server [{0}] is listening on", server.Config.Version);

                // A CoAP endpoint is the source or destination of a CoAP message
                // With no security, the endpoint is solely identified by an
                // IP address and a UDP port number

                foreach (CoAP.Net.IEndPoint item in server.EndPoints)
                {
                    Console.Write(" ");
                    Console.Write(item.LocalEndPoint);
                    // when you run the server this is "[::]:5683"
                }
                Console.WriteLine();
            }
            catch (Exception ex)
            {
                Console.WriteLine(ex.Message);
            }

            Console.WriteLine("Press any key to exit.");
            Console.ReadKey();
        }
    }
}
        
